/**
 * Controls the message drawer.
 *
 * @module     core_message/message_drawer
 * @copyright  2018 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_message/message_drawer",["jquery","core/custom_interaction_events","core/pubsub","core_message/message_drawer_view_contact","core_message/message_drawer_view_contacts","core_message/message_drawer_view_conversation","core_message/message_drawer_view_group_info","core_message/message_drawer_view_overview","core_message/message_drawer_view_search","core_message/message_drawer_view_settings","core_message/message_drawer_router","core_message/message_drawer_routes","core_message/message_drawer_events","core_message/message_drawer_helper","core/pending","core/drawer"],(function($,CustomEvents,PubSub,ViewContact,ViewContacts,ViewConversation,ViewGroupInfo,ViewOverview,ViewSearch,ViewSettings,Router,Routes,Events,Helper,Pending,Drawer){var SELECTORS_DRAWER='[data-region="right-hand-drawer"]',SELECTORS_JUMPTO='.popover-region [data-region="jumpto"]',SELECTORS_PANEL_BODY_CONTAINER='[data-region="panel-body-container"]',SELECTORS_PANEL_HEADER_CONTAINER='[data-region="panel-header-container"]',SELECTORS_VIEW_CONTACT='[data-region="view-contact"]',SELECTORS_VIEW_CONTACTS='[data-region="view-contacts"]',SELECTORS_VIEW_CONVERSATION='[data-region="view-conversation"]',SELECTORS_VIEW_GROUP_INFO='[data-region="view-group-info"]',SELECTORS_VIEW_OVERVIEW='[data-region="view-overview"]',SELECTORS_VIEW_SEARCH='[data-region="view-search"]',SELECTORS_VIEW_SETTINGS='[data-region="view-settings"]',SELECTORS_ROUTES="[data-route]",SELECTORS_ROUTES_BACK="[data-route-back]",SELECTORS_HEADER_CONTAINER='[data-region="header-container"]',SELECTORS_BODY_CONTAINER='[data-region="body-container"]',SELECTORS_FOOTER_CONTAINER='[data-region="footer-container"]',SELECTORS_CLOSE_BUTTON='[data-action="closedrawer"]',routes=[[Routes.VIEW_CONTACT,SELECTORS_VIEW_CONTACT,ViewContact.show,ViewContact.description],[Routes.VIEW_CONTACTS,SELECTORS_VIEW_CONTACTS,ViewContacts.show,ViewContacts.description],[Routes.VIEW_CONVERSATION,SELECTORS_VIEW_CONVERSATION,ViewConversation.show,ViewConversation.description],[Routes.VIEW_GROUP_INFO,SELECTORS_VIEW_GROUP_INFO,ViewGroupInfo.show,ViewGroupInfo.description],[Routes.VIEW_OVERVIEW,SELECTORS_VIEW_OVERVIEW,ViewOverview.show,ViewOverview.description],[Routes.VIEW_SEARCH,SELECTORS_VIEW_SEARCH,ViewSearch.show,ViewSearch.description],[Routes.VIEW_SETTINGS,SELECTORS_VIEW_SETTINGS,ViewSettings.show,ViewSettings.description]],createRoutes=function(namespace,root){routes.forEach((function(route){Router.add(namespace,route[0],function(namespace,root,selector){var header=root.find(SELECTORS_HEADER_CONTAINER).find(selector);header.length||(header=root.find(SELECTORS_PANEL_HEADER_CONTAINER).find(selector));var body=root.find(SELECTORS_BODY_CONTAINER).find(selector);body.length||(body=root.find(SELECTORS_PANEL_BODY_CONTAINER).find(selector));var footer=root.find(SELECTORS_FOOTER_CONTAINER).find(selector);return[namespace,header.length?header:null,body.length?body:null,footer.length?footer:null]}(namespace,root,route[1]),route[2],route[3])}))},show=function(namespace,root){root.attr("data-shown")||(Router.go(namespace,Routes.VIEW_OVERVIEW),root.attr("data-shown",!0));var drawerRoot=Drawer.getDrawerRoot(root);drawerRoot.length&&Drawer.show(drawerRoot)},hide=function(root){var drawerRoot=Drawer.getDrawerRoot(root);drawerRoot.length&&Drawer.hide(drawerRoot)},setJumpFrom=function(buttonid){$(SELECTORS_DRAWER).attr("data-origin",buttonid)},registerEventListeners=function(namespace,root,alwaysVisible){CustomEvents.define(root,[CustomEvents.events.activate]);var paramRegex=/^data-route-param-?(\d*)$/;root.on(CustomEvents.events.activate,SELECTORS_ROUTES,(function(e,data){for(var element=$(e.target).closest(SELECTORS_ROUTES),route=element.attr("data-route"),attributes=[],i=0;i<element[0].attributes.length;i++)attributes.push(element[0].attributes[i]);var paramAttributes=attributes.filter((function(attribute){var name=attribute.nodeName;return paramRegex.test(name)}));paramAttributes.sort((function(a,b){var aParts=paramRegex.exec(a.nodeName),bParts=paramRegex.exec(b.nodeName),aIndex=aParts.length>1?aParts[1]:0,bIndex=bParts.length>1?bParts[1]:0;return aIndex<bIndex?-1:bIndex<aIndex?1:0}));var params=paramAttributes.map((function(attribute){return attribute.nodeValue})),routeParams=[namespace,route].concat(params);Router.go.apply(null,routeParams),data.originalEvent.preventDefault()})),root.on(CustomEvents.events.activate,SELECTORS_ROUTES_BACK,(function(e,data){Router.back(namespace),data.originalEvent.preventDefault()})),root.on("hide.bs.collapse",".collapse",(function(e){var pendingPromise=new Pending;$(e.target).one("hidden.bs.collapse",(function(){pendingPromise.resolve()}))})),root.on("show.bs.collapse",".collapse",(function(e){var pendingPromise=new Pending;$(e.target).one("shown.bs.collapse",(function(){pendingPromise.resolve()}))})),$(SELECTORS_JUMPTO).focus((function(){var firstInput=root.find(SELECTORS_CLOSE_BUTTON);firstInput.length?firstInput.focus():$(SELECTORS_HEADER_CONTAINER).find(SELECTORS_ROUTES_BACK).focus()})),$(SELECTORS_DRAWER).focus((function(){var button=$(this).attr("data-origin");button&&$("#"+button).focus()})),alwaysVisible||(PubSub.subscribe(Events.SHOW,(function(){show(namespace,root)})),PubSub.subscribe(Events.HIDE,(function(){hide(root)})),PubSub.subscribe(Events.TOGGLE_VISIBILITY,(function(buttonid){!function(root){var drawerRoot=Drawer.getDrawerRoot(root);return!drawerRoot.length||Drawer.isVisible(drawerRoot)}(root)?(show(namespace,root),setJumpFrom(buttonid),$(SELECTORS_JUMPTO).attr("tabindex",0)):(hide(root),$(SELECTORS_JUMPTO).attr("tabindex",-1))}))),PubSub.subscribe(Events.SHOW_CONVERSATION,(function(args){setJumpFrom(args.buttonid),show(namespace,root),Router.go(namespace,Routes.VIEW_CONVERSATION,args.conversationid)})),root.find(SELECTORS_CLOSE_BUTTON).on(CustomEvents.events.activate,(function(e,data){data.originalEvent.preventDefault();var button=$(SELECTORS_DRAWER).attr("data-origin");button&&$("#"+button).focus(),PubSub.publish(Events.TOGGLE_VISIBILITY)})),PubSub.subscribe(Events.CREATE_CONVERSATION_WITH_USER,(function(args){setJumpFrom(args.buttonid),show(namespace,root),Router.go(namespace,Routes.VIEW_CONVERSATION,null,"create",args.userid)})),PubSub.subscribe(Events.SHOW_SETTINGS,(function(){show(namespace,root),Router.go(namespace,Routes.VIEW_SETTINGS)})),PubSub.subscribe(Events.PREFERENCES_UPDATED,(function(preferences){var filteredPreferences=preferences.filter((function(preference){return"message_entertosend"==preference.type})),enterToSendPreference=filteredPreferences.length?filteredPreferences[0]:null;enterToSendPreference&&root.find(SELECTORS_FOOTER_CONTAINER).find(SELECTORS_VIEW_CONVERSATION).attr("data-enter-to-send",enterToSendPreference.value)}))};return{init:function(root,uniqueId,alwaysVisible,route){if(root=$(root),createRoutes(uniqueId,root),registerEventListeners(uniqueId,root,alwaysVisible),alwaysVisible&&(show(uniqueId,root),route)){var routeParams=route.params||[];routeParams=[uniqueId,route.path].concat(routeParams),Router.go.apply(null,routeParams)}Helper.markDrawerReady()}}}));

//# sourceMappingURL=message_drawer.min.js.map